/* $Id$ */ 
/* statx.c -- extensions to the sys/stat.h interfaces -- Parts from: */

/* sys/stat.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes 
   See: docs/Copying
		*/
# define INCL_BASE
# define OS2_API32
# define INCL_DOS
#include <os2.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/errnox.h>
#include <sys/timext.h>
#include <sys/stringx.h>

#include <sys/statx.h>

static __inline__ __const__ int __statx_Stat(__const__ char*,struct stat*);
static __inline__ __const__ long int __statx_fTimeDate2Time_T(FTIME,FDATE);

extern time_t _mktime(struct tm*); /* lib module version of ANSI fn */
extern int _trslash(__const__ char *, size_t, int);

	static __inline__ __const__ long int
__statx_fTimeDate2Time_T(__const__ FTIME ft, __const__ FDATE fd)
{
 struct tm tmBuf;
	tmBuf.tm_sec = ft.twosecs * 2;
	tmBuf.tm_min = ft.minutes;
	tmBuf.tm_hour = ft.hours;
	tmBuf.tm_mday = fd.day;
	tmBuf.tm_mon = fd.month - 1;
	tmBuf.tm_year = fd.year + 1980 - 1900;
	tmBuf.tm_isdst = -1;             /* unknown */
	return _mktime(&tmBuf);
}
							
#define FTIMEZEROP(x) (*(USHORT*)&(x) == 0)
#define FDATEZEROP(x) (*(USHORT*)&(x) == 0)

long __statx_inodeNumberCounter = 0x100000; /* global inode counter */

	static __inline__ __const__ int   /* internal wrapper: kernel interface */
__statx_Stat(__const__ char *name, struct stat *statPbuf) 
{
 memset(statPbuf, 0, sizeof(*statPbuf));

 if ((name[0] == '/' || name[0] == '\\') && strlen(name) >= 6 &&
      memicmp(name+1, "pipe", 4) == 0 && (name[5] == '/' || name[5] == '\\')) {
      errno = ENOENT; return -1; /* Fix me ! Todo: Posix named pipes/mkfifo() */
 } else {
 __const__ FILESTATUS3 filestatus3Info;
 __const__ APIRET rc = 
  DosQueryPathInfo(name, FIL_STANDARD, (PFILESTATUS3)&filestatus3Info,
  			sizeof(filestatus3Info));
  if (rc) { errno = _rc2Errno(rc); return(-1); }

  statPbuf->st_attr = filestatus3Info.attrFile;
  statPbuf->st_reserved = 0;
  statPbuf->st_mtime = __statx_fTimeDate2Time_T(filestatus3Info.ftimeLastWrite,
						 filestatus3Info.fdateLastWrite);
  if (FTIMEZEROP (filestatus3Info.ftimeCreation) &&
      FDATEZEROP (filestatus3Info.fdateCreation))
    statPbuf->st_ctime = statPbuf->st_mtime;
  else
    statPbuf->st_ctime = __statx_fTimeDate2Time_T(filestatus3Info.ftimeCreation,
						 filestatus3Info.fdateCreation);
  if (FTIMEZEROP(filestatus3Info.ftimeLastAccess) &&
      		FDATEZEROP(filestatus3Info.fdateLastAccess))
    statPbuf->st_atime = statPbuf->st_mtime;
  else
    statPbuf->st_atime = __statx_fTimeDate2Time_T(filestatus3Info.ftimeLastAccess,
							 filestatus3Info.fdateLastAccess);
  if (filestatus3Info.attrFile & 0x10) { /* directory */
      statPbuf->st_mode = S_IFDIR;
      statPbuf->st_mode |= ((S_IREAD|S_IWRITE|S_IEXEC) >> 6) * 0111;
      statPbuf->st_size = 0;
  }  else {
      statPbuf->st_size = filestatus3Info.cbFile;
      statPbuf->st_mode = S_IFREG;
      if (filestatus3Info.attrFile & 1)
        statPbuf->st_mode |= (S_IREAD >> 6) * 0111;
      else
        statPbuf->st_mode |= ((S_IREAD|S_IWRITE) >> 6) * 0111;
  }		/* The following is reserved for future Posix-file-system emulation */
  statPbuf->st_uid = 0; 
  statPbuf->st_gid = 0;
  statPbuf->st_ino = __statx_inodeNumberCounter++; /* incremented; fix me ! */
  if (__statx_inodeNumberCounter == 0)
  	__statx_inodeNumberCounter = 1; /* wrap? */
  statPbuf->st_dev = 0;
  statPbuf->st_rdev = 0;
  statPbuf->st_nlink = 1;
#ifndef _POSIX_SOURCE /* BSD compatibility hacks: Fix me! */
  statPbuf->st_blksize = 512; /* preferred blocksize: Assume HPFS: 512; Fix me! */
  statPbuf->st_blocks = (statPbuf->st_size / 512) + 1;
#endif
  return(0);
 }
}
	extern int 	/* The public interface: Sanity check; call wrapper */
_stat(const char *name, struct stat *buffer)
{
 __const__ size_t
 	len = strlen(name); /* Strip any trailing slash/backslash: */
  if ( _strHasTrailingSlash(name, len, 1) ) { /* trailing slash detected... */
    if ( (buffer->st_mode & S_IFMT) != S_IFDIR ) { /* but not a directory !? */
      errno = ENOTDIR; return(-1);
    } else {
     char *tmp = __builtin_alloca(len);	/* using local copy tmp */
     memcpy(tmp, name, len - 1);
     tmp[len-1] = 0; /* zero the trailing */
     name = tmp;
  }
  if ( __statx_Stat(name, buffer) )  /* Error, errno already set */
    return(-1);
  if (!_tzset_flag)  _tzset();

  _localtime2gmt(&buffer->st_atime, -1);
  _localtime2gmt(&buffer->st_mtime, -1);
  _localtime2gmt(&buffer->st_ctime, -1);

  if ((buffer->st_mode & S_IFMT) == S_IFREG) {
    char *buf = _getext(name);
    if (buf != NULL && 		/* depend on suffix: Fix me! */
              (_stricmp (buf, ".exe") == 0 ||
               _stricmp (buf, ".com") == 0 ||
               _stricmp (buf, ".cmd") == 0 ||
               _stricmp (buf, ".bat") == 0) )
        buffer->st_mode |= (S_IEXEC >> 6) * 0111;
    }
  }
  return(0);
}

/* --- lstat() dummy implementation --- released into Public Domain */
	extern int
_lstat(const char *path, struct stat *statPbuf)
{
 __const__ int statrc =
 	__statx_Stat(path, statPbuf);  /* to ease debugging */
  
  fputs("libextensions: _lstat(): _lstat() mapped to _stat()!\n",stderr);
  return(statrc);
}
   /* lstat() is the very same as stat() except when a symbolic
   link is being specified: while stat() resolves the link, lstat() 
   doesn't dereference it.
   However to be on the safe for future enhancements we
   don't #define lstat to stat even if by default OS/2
   has no filesystems supporting symbolic links.
   To be on the safe side we create an entry point for
   lstat() in libextension however!

   The linux manpage gives lstat as conforming to 4.3BSD and SVr4,
   it also appears in SUSV2.  */



/* fchmod():   change permission of a file.  -- emx/gcc --     */

	extern int  				/* References:  4.4BSD and SVr4 */
_fchmod(const int filedes, const mode_t mode)
{
	/* our implementation has similar limits as chmod(), therefore
	 * read the according section in the EMX docs.
	 * TODO: improve analysis when it fails, see below
	   */
	if (mode < S_IXOTH || mode > 
			(S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO) ) {
		errno = EINVAL;	return(-1);
	} else {
	 const int htype;
		if ( _ioctl(filedes, FGETHTYPE, (int)&htype) ) { /* is fd okay? */
			/* errno = EBADF; */ /* errno set by ioctl */
			return(-1);
		}
		if ( HT_ISDEV(htype) ) {  /* cannot fchmod() clock, ttys, etc. */
			errno = EINVAL; return(-1);
		}
		/* we assume that _POSIX_SOURCE is not! defined now: 
		    file _must_ be writable/readable or readable */
		if (!(mode & S_IREAD)) {
			fputs("\
libextensions: fchmod(): File is not readable. FAT and HPFS do not allow this\n",stderr);
			errno = EINVAL;	return(-1);
		}
	}{		 		/* end of sanity checks; begin of main block */
	 FILESTATUS3 fsts3FileInfo;				/* file information   */
	 ULONG attr = FILE_READONLY;
	 APIRET rc = 		  				/* Get standard info */
		DosQueryFileInfo((HFILE)filedes, FIL_STANDARD, &fsts3FileInfo,
		 					sizeof(FILESTATUS3));
		if (rc) {
				_dPrintf("DosQueryFileInfo error: return code = %lu\n", rc);
				errno = _rc2Errno(rc); return(-1);
		}
		if (mode & S_IWRITE)
			attr = FILE_NORMAL; 
		fsts3FileInfo.attrFile  = attr;

		rc = DosSetFileInfo((HFILE)filedes, FIL_STANDARD,
					(PFILESTATUS3)&fsts3FileInfo, sizeof(FILESTATUS3));
		if (rc) {
			_dPrintf("DosSetfFileInfo error: return code = %lu\n", rc);
			errno = _rc2Errno(rc); return(-1);
		}
		return 0; /* success */
	}
}


extern int stat(const char*p,struct stat*b){return _stat(p,b);}
extern int lstat(const char*p,struct stat*b){return _lstat(p,b);}
extern int fchmod(const int f, const mode_t m){return _fchmod(f,m);}

