/* -- sys/unistdx.h (libext+gcc) -- to be included in unistd.h
	$Id: unistdx.h,v 1.10 2000/05/31 09:12:05 veit Exp $  
  */

#ifndef _SYS_UNISTDX_H
#define _SYS_UNISTDX_H

#ifndef	_POSIX_SOURCE
# include <sys/types.h>
# ifndef _XOPEN_SOURCE
#  include <sys/time.h>	/* structure timeval required for select() */
#  include <sys/select.h>
# endif
# include <unistd.h>
#endif

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
#  define __const__  const
# endif
extern "C" {
#endif

#ifndef _POSIX_OS2_ROOT    /* ((__const__ char*)_getenv(POSIXOS2ROOT)) 	"/" */
extern __const__ char*_getPosixOS2Root(void); 		/* cf. param.c */
#define _POSIX_OS2_ROOT _getPosixOS2Root()
#endif 

 /* max bytes of fully qualified path name: a file system property */

#ifndef PATH_MAX  /* OS/2 does not use a constant but a FS query */
extern __const__ int _mxPath(void);
#define PATH_MAX _mxPath() /* return maximal path length or -1 (error) */
#endif /* ! PATH_MAX */

#ifndef	_POSIX2_RE_DUP_MAX
#define	_POSIX2_RE_DUP_MAX	255
#endif

#if !defined (_UID_T)
# define _UID_T
   typedef int uid_t;
#endif
#if !defined (_GID_T)
# define _GID_T
   typedef int gid_t;
#endif

#ifdef _CPYFILE_FOR_SYMLINK  /* Fake symlink() by copying */
# define symlink(i,o) _symLink1(i,o)
# define _symlink(i,o) _symLink1(i,o)
#else				/* Simply return EPERM */
# define symlink(i,o) _symLink2(i,o)
# define _symlink(i,o) _symLink2(i,o)
#endif

#ifdef _USE_HRTIMER_SYS 
# define usleep _uSleep1
# define _usleep _uSleep1
#else	/* DosSleep() with resolution of milliseconds. */ 
# define usleep _uSleep2
# define _usleep _uSleep2
#endif

extern unsigned int alarm(unsigned int);

extern int _sync(void); /* NAME sync - fight paranoia, commit cache to disk 
   SYNOPSYS: 
       #include <unistd.h>  [here we may find the system's sync()]
       int sync(void); 
    RETURNS: 
        sync() always returns 0  */ 

extern int _cpFile(__const__ char*,__const__ char*);
/* Copy file from in_name to out_name.  Returns:
   0 if all's well
  -1 on error:  errno is set accordingly
 * Curtis W. Rendon 12/20/1999 initial (modified 04/01/00 A. Hanses)
 * hereby released to the public domain, please keep my comments,
 * no warranty inferred, implied, or specified.
 *  Curtis W. Rendon mithra@earthling.net  12/29/1999
 */
extern int _chown(__const__ char*,uid_t, gid_t);    /* stub fn */
extern int _lchown(__const__ char*,uid_t, gid_t);    /* stub fn */
extern int _fchown(int,uid_t, gid_t);			/* stub fn */
extern char *_getwd(char *buf);
extern int _initHrTimer(void);  /* Open the HR-Timer, initialize it, 
	call this fn before doing any timings,  RETURNS  0, on success -1, 
        on error, ERRNO is set accordingly call once at the beginning of your 
        program or when inializing your dll */
extern int _termHrTimer(void); /* Close the hfTimer, do cleanup, 
	call this fn after doing all timings:
   RETURNS
         0, on success
        -1, on error, ERRNO is set accordingly */
extern void _uSleep1(__const__ unsigned long int ulMcsec);
extern void _uSleep2(__const__ unsigned long int ulMcsec); /* sleep for 
	ulWait microseconds */
extern int _symLink1(__const__ char*,__const__ char*);
extern int _symLink2(__const__ char*,__const__ char*);

extern int _maxPathLen(void);	 /* maximal path length */
extern pid_t vfork(void); 
extern int sync(void); 
extern int chown(__const__ char *path, uid_t owner, gid_t group);
extern int lchown(__const__ char *path, uid_t owner, gid_t group);

# ifndef _POSIX_SOURCE

extern int fchown(int filedes, uid_t owner, gid_t group);
#  undef getpagesize()
extern const int getpagesize(void);
#  define getpagesize() 0x1000
extern char *getwd(char *buf);
extern void* valloc(size_t);
extern int getdtablesize(void);
char*getwd(char*);		/* obsoleted by getcwd() */
extern int gethostid(void);            /* BSD: long gethostid(); */
extern int sethostid(long);            /* dummy fn; cf. tcpip configuration */
extern int readlink(__const__ char*,char*,size_t);
extern char *re_comp(__const__ char*); 	/* BSD 4.3 compatibility */
extern int re_exec(__const__ char *); 	/* BSD 4.3 compatibility */
extern int nice(int);
extern useconds_t ualarm(useconds_t,useconds_t);

#endif /* ! _POSIX_SOURCE */ 

/* Machine-dependent inline versions */
#if !(!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))

extern __inline__ pid_t vfork(void) {return _fork();}
extern __inline__ int   sync(void)  {return _sync();}
extern __inline__ int   chown(__const__ char*p,uid_t o,gid_t g)
	{return _chown(p,o,g);}
#ifndef	_POSIX_SOURCE
extern __inline__ int 
 fchown(int f,uid_t o,gid_t g){return _fchown(f,o,g);}
#endif
	extern __inline__ int 
 lchown(__const__ char*p,uid_t o,gid_t g){return _chown(p,o,g);}

#endif 		/* !__GNUC__, etc. */

#if defined (__cplusplus)
}
#endif

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* _SYS_UNISTDX_H */
