/* limits.h (libext+gcc) */
/* $Id: limits.h,v 1.5 2000/07/06 07:04:36 veit Exp $ */

/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)limits.h	5.9 (Berkeley) 4/3/91
 */

#ifndef _LIMITS_H
#define _LIMITS_H

#define CHAR_BIT      8
#define SCHAR_MIN   (-128)
#define SCHAR_MAX     127
#define UCHAR_MAX     0xffU
#if defined (__CHAR_UNSIGNED__)
#define CHAR_MIN      0
#define CHAR_MAX      UCHAR_MAX
#else
#define CHAR_MIN      SCHAR_MIN
#define CHAR_MAX      SCHAR_MAX
#endif
#define MB_LEN_MAX    6
#define SHRT_MIN    (-32768)
#define SHRT_MAX      32767
#define USHRT_MAX     0xffffU
#define LONG_MIN    (-0x7fffffffL-1L)
#define LONG_MAX      0x7fffffffL
#define ULONG_MAX     0xffffffffUL
#define INT_MIN     (-0x7fffffff-1)
#define INT_MAX       0x7fffffff
#define UINT_MAX      0xffffffffU


#ifndef __STRICT_ANSI__

#define	SSIZE_MAX	INT_MAX		/* max value for a ssize_t */

/* only default/minimal values; do not use */

#define _POSIX_ARG_MAX          4096
#define _POSIX_CHILD_MAX        6
#define _POSIX_LINK_MAX         8
#define _POSIX_MAX_CANON        255
#define _POSIX_MAX_INPUT        255
#define _POSIX_NAME_MAX         14
#define _POSIX_NGROUPS_MAX      0
#define _POSIX_OPEN_MAX         16
#define _POSIX_PATH_MAX         255
#define _POSIX_PIPE_BUF         512
#define _POSIX_SSIZE_MAX        32767
#define _POSIX_STREAM_MAX       8
#define _POSIX_TZNAME_MAX       3
#define SSIZE_MAX               INT_MAX

#define	_POSIX2_BC_BASE_MAX	99
#define	_POSIX2_BC_DIM_MAX	2048
#define	_POSIX2_BC_SCALE_MAX	99
#define	_POSIX2_BC_STRING_MAX	1000
#define	_POSIX2_COLL_WEIGHTS_MAX	2
#define	_POSIX2_EXPR_NEST_MAX	32
#define	_POSIX2_LINE_MAX	2048
#define	_POSIX2_RE_DUP_MAX	255

/* P1003.1c */
#define _POSIX_TTY_NAME_MAX	260
#define _POSIX_LOGIN_NAME_MAX	MAXLOGNAME

/* where does this belong? it is defined by P1003.1c */
#define TTY_NAME_MAX		_POSIX_TTY_NAME_MAX
#define LOGIN_NAME_MAX		MAXLOGNAME

#if !defined(_POSIX_SOURCE) || defined(_XOPEN_SOURCE)
#define PASS_MAX		128

#define NL_ARGMAX		9
#define NL_LANGMAX		14
#define NL_MSGMAX		32767
#define NL_NMAX			1
#define NL_SETMAX		255
#define NL_TEXTMAX		255

#if !defined (TMP_MAX)
#define TMP_MAX         1000
#endif
#endif /* !_POSIX_SOURCE || _XOPEN_SOURCE */
#if !defined(_POSIX_SOURCE) && !defined(_XOPEN_SOURCE)
#define	SIZE_T_MAX	UINT_MAX	/* max value for a size_t */

#define	UID_MAX		INT_MAX		/* max value for a uid_t */
#define	GID_MAX		INT_MAX		/* max value for a gid_t */

#define	ULLONG_MAX  0xffffffffffffffffULL
#define	UQUAD_MAX       0xffffffffffffffffULL	/* max unsigned quad */
#define LLONG_MAX   0x7fffffffffffffffLL
#define	QUAD_MAX        0x7fffffffffffffffLL	  /* max signed quad */
#define LLONG_MIN  (-0x7fffffffffffffffLL-1LL)
#define	QUAD_MIN       (-0x7fffffffffffffffLL-1LL) /* min signed quad */

#define USI_MAX         UINT_MAX
#endif /* !_POSIX_SOURCE && !_XOPEN_SOURCE */

#if !defined(_POSIX_SOURCE) || defined(_XOPEN_SOURCE)
#define LONG_BIT	32
#define WORD_BIT	32

#define DBL_DIG		15
#define DBL_MAX		1.7976931348623157E+308
#define DBL_MIN		2.2250738585072014E-308

#define FLT_DIG		6
#define FLT_MAX		3.40282347E+38F
#define FLT_MIN		1.17549435E-38F
#endif

#endif /* !__STRICT_ANSI__ */
#endif /* not _LIMITS_H */
