/* $ID msgx.c (libextensions/gcc) */

/* msgget,msgsnd,msgrcv by Stauff__ .  Use this funcs as you wish 
 			Current version 0.1 Alpha
   Limitations: msgsnd waiting mode will not be implemented 
   Only multy-threaded apps and fork() are supported for now
   msgctl coming in next version
   */

#define INCL_DOSQUEUES   /* DOS Queue values */
#define INCL_DOSPROCESS  /* DOS thread and process values */
#define INCL_DOSERRORS   /* DOS error values */
#include <os2.h>

#include <sys/types.h> 
#include <sys/ipc.h> 
#include <sys/msg.h> 
#include <sys/stat.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/errnox.h>

	extern int
msgget(key_t qkey, int flags) 		/* flags are not used for now ?? */
{
 char  szQueName[50]      = "/QUEUES/EMX.";
 char	buffer[10];
 HQUEUE      hqSpecialQue = NULLHANDLE; /* Queue handle */
 PID         pidOwner     = 0;
 APIRET      rc           = NO_ERROR;   /* Return code  */
   
	strcat(szQueName,(char*)_itoa(qkey,buffer,10));
    
	if (flags==0) {
		rc = DosOpenQueue (&pidOwner,   /* PID of queue owner         */
				&hqSpecialQue, /* Handle for created queue   */
				szQueName);    /* Name of the queue to open  */
		if (rc!= NO_ERROR) {
			_dPrintf(
"\nmsgget():DosOpenQueue error: Return code = %u\n", (int)rc);
			errno = _rc2Errno(rc); return(-1);
		}
	} else  {
		rc = DosCreateQueue(&hqSpecialQue,  /* Queue handle                  */
			QUE_FIFO,                   /* Convert 16-bit addresses to 32  */
			szQueName);                 /* Name of the queue to create     */
		if (rc!= NO_ERROR) {
			_dPrintf(
"\nmsgget():DosCreateQueue error: return code = %u\n", (int)rc);
			errno = _rc2Errno(rc); return(-1);
		}
	} 
	return qkey;
}

	extern int
msgsnd(int msgq_id, const void *messbuf, size_t msgsize,int dummy_flags)
{
/* flags are not used for now */
 char  szQueName[50]      = "/QUEUES/EMX.";
 char  szMemName[50]      = "/SHAREMEM/EMX.";
 char	buffer[10];
 HQUEUE      hqSpecialQue = NULLHANDLE; /* Queue handle                   */
 PID         pidOwner     = 0;
 APIRET      rc           = NO_ERROR;   /* Return code                    */
 PVOID       pObject = NULL;            /* Pointer to shared memory obj   */

 static struct tmsgbuf *rootmsg;      
 static long msg_calls=20;            /* Magic Number ;) */
 static int asize=-1;
 int z;
	
	if (!rootmsg) {
		rootmsg=(struct tmsgbuf*)malloc(sizeof(struct tmsgbuf));
		asize=0;
	} else  {
		asize++;
		rootmsg = (struct tmsgbuf*)
			realloc(rootmsg,(asize+1)*sizeof(struct tmsgbuf));
	}
	strcat(szQueName,(char*)_itoa(msgq_id, buffer, 10));
	strcat(szMemName,(char*)_itoa(msgq_id, buffer,10));
	strcat(szMemName,(char*)_itoa(msg_calls,buffer,10));   
	
	rc = DosAllocSharedMem(&pObject,       /* Pointer to object pointer     */
		szMemName,      /* Name for shared memory        */
		msgsize,        /* Desired size of object        */
		PAG_COMMIT |    /* Commit memory                 */
		PAG_WRITE );    /* Allocate memory as read/write */
	
	if (rc != NO_ERROR) {
		 _dPrintf(
"\nmsgsnd():DosAllocSharedMem error:  return code = %u\n",(int)rc);
		errno = _rc2Errno(rc); return(-1);
	}

	memcpy(pObject,messbuf,msgsize);
	rootmsg[asize].ptr=pObject;
	rootmsg[asize].msg=msg_calls;
	
	rc = DosOpenQueue (&pidOwner,         /* PID of queue owner              */
		&hqSpecialQue,     /* Handle for created queue        */
		szQueName);      /* Name of the queue to open       */
	if (rc!= NO_ERROR) {
		_dPrintf("\nmsgsnd():DosOpenQueue error: Return code = %u\n", (int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	rc = DosWriteQueue (hqSpecialQue,    /* Queue to write to           */
			(ULONG)msgsize,      /* Request data                */
			sizeof(long),        /* Length of data to write     */
			(PVOID)msg_calls++,  /* Pointer to data             */
			0L);                 /* Priority (not applicable here) */
	if (rc!= NO_ERROR) {
		_dPrintf("\nmsgsnd():DosWriteQueue error: return code = %u\n", (int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	for (z=0;z<=asize;z++) {
		struct tmsgbuf *rtmpmsg;
		
		if (strcmp((char*)rootmsg[z].ptr,_itoa(rootmsg[z].msg,buffer,10))==0) {
			rtmpmsg=(struct tmsgbuf*)malloc(asize*sizeof(struct tmsgbuf));
			memcpy(rtmpmsg,rootmsg,z*sizeof(struct tmsgbuf));
			memcpy(rtmpmsg+z,rootmsg+1,(asize-z)*sizeof(struct tmsgbuf));
			
			rc = DosFreeMem(rootmsg[z--].ptr);
			if (rc != NO_ERROR) {
				printf(
"\nmsgrcv():DosFreeMem error:  return code = %u\n",(int)rc);
				errno = _rc2Errno(rc); return(-1);
			}
			free(rootmsg);         
			rootmsg=rtmpmsg; 
			asize--;
		}
	}
	return 0;     
}
  
	extern int
msgrcv(int qkey, void *msgp, size_t dummy_msgsz, long dummy_msgtyp, int msgflg)
{ 
	/* msgsz and  __msgtyp are still a mistery to me */
 char  szQueName[50]      = "/QUEUES/EMX.";
 char  szMemName[50]      = "/SHAREMEM/EMX.";
 char	buffer[10];
 HQUEUE      hqSpecialQue = NULLHANDLE; /* Queue handle                   */
 long        DataBuffer   = 0;          /* Data buffer for queue data     */
 REQUESTDATA Request      = {0};        /* Reques */
 PID         pidOwner     = 0;
 ULONG       ulDataLen    = 0;          /* Length of data returned        */
 BYTE        ElemPrty     = 0;          /* Priority of element (returned) */
 APIRET      rc           = NO_ERROR;   /* Return code                    */
 PVOID       pObject = NULL;            /* Pointer to shared memory object*/
 ULONG       ulNumElems;

	strcat(szQueName,(char*)_itoa(qkey,buffer,10));

	rc = DosOpenQueue (&pidOwner,    /* PID of queue owner              */
			&hqSpecialQue,   /* Handle for created queue        */
			szQueName);      /* Name of the queue to open       */
	if (rc!= NO_ERROR) {
		_dPrintf("msgrcv():DosOpenQueue error: return code = %u\n", (int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	
	rc = DosQueryQueue (hqSpecialQue, &ulNumElems);
	if (rc != NO_ERROR) {
		_dPrintf("\nmsgrcv():DosQueryQueue error: return code = %u\n", (int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	
	/* Thus we use IPC_NOWAIT mode, and no semaphores for now */   
	if ((ulNumElems==0)&& (msgflg==IPC_NOWAIT))
		return -1;
		 
	Request.pid = pidOwner;           /* process ID for the DosReadQueue */
	 
	rc = DosReadQueue (hqSpecialQue,       /* Queue to read from          */
		&Request,           /* Request data from write     */
		&ulDataLen,         /* Length of data returned     */
		(PVOID)&DataBuffer, /* The data                    */
		0L,                 /* Remove first element        */
		DCWW_WAIT,          /* Wait for available data     */
		&ElemPrty,          /* Priority of data (returned) */
		0L);                /* Semaphore to use when not waiting */
										 
	if (rc!= NO_ERROR) {
		_dPrintf("\nmsgrcv():DosReadQueue error: return code = %u\n", (int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	strcat(szMemName,(char*)_itoa(qkey,buffer,10));
	strcat(szMemName,(char*)_itoa(DataBuffer,buffer,10));          
	
	rc = DosGetNamedSharedMem(&pObject,     /* Pointer to pointer of object */
		szMemName,    /* Name of shared memory        */
		PAG_WRITE);   /* Want read-write access       */
	if (rc != NO_ERROR) {
		_dPrintf("\nmsgrcv():DosGetNamedSharedMem error:  return code = %u\n",
		 				(int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	memcpy(msgp,pObject,Request.ulData);
	memcpy(pObject,_itoa(DataBuffer,buffer,10),Request.ulData);
	
	rc = DosFreeMem(pObject);
	if (rc != NO_ERROR) {
		_dPrintf("\nmsgrcv():DosFreeMem error:  return code = %u\n",(int)rc);
		errno = _rc2Errno(rc); return(-1);
	}
	return(Request.ulData);			 /* ? What to return actually ? ;) */
}

/*
 * Copyright (c) 1994 SigmaSoft, Th. Lockert <tholo@sigmasoft.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

	key_t
ftok(const char *path, int id)
{
	struct stat st;

	if (stat(path, &st) < 0)
		return (key_t)-1;

	return (key_t)
	    ((id & 0xff) << 24 | (st.st_dev & 0xff) << 16 | (st.st_ino & 0xffff));
}
