/* $Id: unistdx.h,v 1.1 2000/03/14 08:39:24 veit Exp $ */ /* -- sys/unistd.h  for emx/OS2 -- (for inclusion to unistd.h) 
   This stuff should be included in <unistd.h> ...
   This code is released into Public Domain. */

#ifndef _SYS_UNISTDX_H
#define _SYS_UNISTDX_H

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

 /* max bytes of fully qualified path name: a file system property */

#ifndef PATH_MAX  /* OS/2 does not use a constant but a FS query */
#define PATH_MAX _mxPath() /* return maximal path length or -1 (error) */
extern int _mxPath(void);
#endif /* ! PATH_MAX */

#ifndef	_POSIX2_RE_DUP_MAX
#define	_POSIX2_RE_DUP_MAX	255
#endif

#if !defined (_UID_T)
# define _UID_T
   typedef int uid_t;
#endif
#if !defined (_GID_T)
# define _GID_T
   typedef int gid_t;
#endif

#ifdef _CPYFILE_FOR_SYMLINK  /* Fake symlink() by copying */
# define symlink(i,o) _symLink1(i,o)
# define _symlink(i,o) _symLink1(i,o)
#else				/* Simply return EPERM */
# define symlink(i,o) _symLink2(i,o)
# define _symlink(i,o) _symLink2(i,o)
#endif

#ifdef _USE_HRTIMER_SYS 
# define usleep _uSleep1
# define _usleep _uSleep1
#else	/* DosSleep() with resolution of milliseconds. */ 
# define usleep _uSleep2
# define _usleep _uSleep2
#endif

extern int _sync(void); /* NAME sync - fight paranoia, commit cache to disk 
   SYNOPSYS: 
       #include <unistd.h>  [here we may find the system's sync()]
       int sync(void); 
    RETURNS: 
        sync() always returns 0  */ 

extern int _cpFile(__const__ char*,__const__ char*);
/* Copy file from in_name to out_name.  Returns:
   0 if all's well
  -1 on error:  errno is set accordingly
 * Curtis W. Rendon 12/20/1999 initial (modified 04/01/00 A. Hanses)
 * hereby released to the public domain, please keep my comments,
 * no warranty inferred, implied, or specified.
 *  Curtis W. Rendon mithra@earthling.net  12/29/1999
 */
extern int _chown(__const__ char*,uid_t, gid_t);    /* stub fn */
extern int _lchown(__const__ char*,uid_t, gid_t);    /* stub fn */
extern int _fchown(__const__ int,uid_t, gid_t);    /* stub fn */
extern int _initHrTimer(void);  /* Open the HR-Timer, initialize it, 
	call this fn before doing any timings,  RETURNS  0, on success -1, 
        on error, ERRNO is set accordingly call once at the beginning of your 
        program or when inializing your dll */
extern int _termHrTimer(void); /* Close the hfTimer, do cleanup, 
	call this fn after doing all timings:
   RETURNS
         0, on success
        -1, on error, ERRNO is set accordingly */
extern void _uSleep1(__const__ unsigned long int ulMcsec);
extern void _uSleep2(__const__ unsigned long int ulMcsec); /* sleep for 
	ulWait microseconds */
extern int _symLink1(__const__ char*,__const__ char*);
extern int _symLink2(__const__ char*,__const__ char*);

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
extern int _maxPathLen(void);	 /* maximal path length */
extern int sync(void); 
extern int chown(__const__ char *path, uid_t owner, gid_t group);
extern int lchown(__const__ char *path, uid_t owner, gid_t group);
extern int fchown(__const__ int filedes, uid_t owner, gid_t group);
# if defined (__cplusplus)
 }
# endif
#else
extern __inline__ int _maxPathLen(void);	 /* maximal path length */
extern __inline__ int sync(void); 
extern __inline__ int chown(__const__ char *path, uid_t owner, gid_t group);
extern __inline__ int lchown(__const__ char *path, uid_t owner, gid_t group);
extern __inline__ int fchown(__const__ int filedes, uid_t owner, gid_t group);
# if defined (__cplusplus)
 }
# endif
	extern __inline__ int 
 sync(void){return _sync();}
	extern __inline__ int 
 chown(__const__ char*p,uid_t o,gid_t g){return _chown(p,o,g);}
	extern __inline__ int 
 lchown(__const__ char*p,uid_t o,gid_t g){return _chown(p,o,g);}
	extern __inline__ int 
 fchown(__const__ int f,uid_t o,gid_t g){return _fchown(f,o,g);}
#endif 		/* !__GNUC__, etc. */

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* _SYS_UNISTDX_H */
