/*
 * Copyright 1998 Antony T Curtis <antony.curtis@olcs.net>
 * Use restricted to and permitted only for OS/2. Minimum royalty 
 * for use on Microsoft platforms at $1000 per annum per seat.
 *
 * This library is to override existing calls so that they may be 
 * aborted by signals from other threads using the mechanisms 
 * within pthreads
 */
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifdef _THREAD_SAFE
#include <pthread.h>
#include "pthread_private.h"

int pthread_write(int fd, const void *buf, size_t len)
{
  int		rc = 0;
  pthread_t	thread_ptr = pthread_self();

  thread_ptr->data.fd.fd = fd;
  thread_ptr->data.fd.branch = __LINE__;
  thread_ptr->data.fd.fname = __FILE__;
  thread_ptr->state = PS_FDW_WAIT;
  rc = _write(fd,buf,len);
  thread_ptr->state = PS_RUNNING;
  if (rc == -1 && errno == EINTR) {
    thread_ptr->sig_pending = 0;
    _sys_deliver_pending_signals(&thread_ptr->tp);
    _setsyserrno(EINTR);
  }
  return (rc);
}

int write(int fd, const void *buf, size_t len)
{
  return pthread_write(fd,buf,len);
}

int pthread_send(int fd, const void *buf, int len, int opt)
{
  int		rc = 0;
  pthread_t	thread_ptr = pthread_self();

  thread_ptr->data.fd.fd = fd;
  thread_ptr->data.fd.branch = __LINE__;
  thread_ptr->data.fd.fname = __FILE__;
  thread_ptr->state = PS_FDW_WAIT;
  rc = send(fd,buf,len,opt);
  thread_ptr->state = PS_RUNNING;
  if (rc == -1 && errno == EINTR) {
    thread_ptr->sig_pending = 0;
    _sys_deliver_pending_signals(&thread_ptr->tp);
    _setsyserrno(EINTR);
  }
  return (rc);
}

int pthread_sendto(int fd, const void *buf, int len, int opt, const struct sockaddr *to, int tosize)
{
  int		rc = 0;
  pthread_t	thread_ptr = pthread_self();

  thread_ptr->data.fd.fd = fd;
  thread_ptr->data.fd.branch = __LINE__;
  thread_ptr->data.fd.fname = __FILE__;
  thread_ptr->state = PS_FDW_WAIT;
  rc = sendto(fd,buf,len,opt,to,tosize);
  thread_ptr->state = PS_RUNNING;
  if (rc == -1 && errno == EINTR) {
    thread_ptr->sig_pending = 0;
    _sys_deliver_pending_signals(&thread_ptr->tp);
    _setsyserrno(EINTR);
  }
  return (rc);
}

int pthread_connect(int fd, const struct sockaddr *to, int tosize)
{
  int		rc = 0;
  pthread_t	thread_ptr = pthread_self();

  thread_ptr->data.fd.fd = fd;
  thread_ptr->data.fd.branch = __LINE__;
  thread_ptr->data.fd.fname = __FILE__;
  thread_ptr->state = PS_FDW_WAIT;
  rc = connect(fd,to,tosize);
  thread_ptr->state = PS_RUNNING;
  if (rc == -1 && errno == EINTR) {
    thread_ptr->sig_pending = 0;
    _sys_deliver_pending_signals(&thread_ptr->tp);
    _setsyserrno(EINTR);
  }
  return (rc);
}


#endif
