/*
 * Copyright 1998 Antony T Curtis <antony.curtis@olcs.net>
 * Use restricted to and permitted only for OS/2. Minimum royalty 
 * for use on Microsoft platforms at $1000 per annum per seat.
 *
 * This library is to override existing calls so that signals may
 * emulated as unix programs expect.
 */
#include <stdarg.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#ifdef _THREAD_SAFE
#include <pthread.h>
#include "pthread_private.h"

int pthread_fcntl(int fd, int request, ...)
{
	va_list		va;
	FILELOCK	LockArea = {0,0}, UnlockArea = {0,0};
	int		lockflags = 0, arg;
	pthread_t	self = pthread_self();
	struct flock	*lockinfo;
	APIRET		rc = -1;

	switch (request) {
	case F_GETFL:
		return fcntl(fd, F_GETFL);
	case F_SETFL:
	case F_GETFD:
	case F_SETFD:
	case F_DUPFD:
		va_start(va, request);
		arg = va_arg(va, int);
		va_end(va);
		return fcntl(fd, F_SETFL, arg);
	case F_SETLK:
	case F_SETLKW:
		va_start(va, request);
		lockinfo = va_arg(va, struct flock *);
		va_end(va);
		if (!lockinfo) break;

		if (lockinfo->l_type == F_UNLCK) {
			UnlockArea.lOffset = lockinfo->l_start;
			UnlockArea.lRange = lockinfo->l_len;
			if (!UnlockArea.lRange)
				UnlockArea.lRange = 0x7fffffffL;
		} else
		if (lockinfo->l_type == F_RDLCK || lockinfo->l_type == F_WRLCK) {
			LockArea.lOffset = lockinfo->l_start;
			LockArea.lRange = lockinfo->l_len;
			if (!LockArea.lRange)
				LockArea.lRange = 0x7fffffffL;
			if (lockinfo->l_type == F_RDLCK)
				lockflags |= 1;
		} else break;
		
		rc = DosSetFileLocks(fd,&UnlockArea,&LockArea,0,lockflags);
		if (rc == 175 && lockflags & 1) {
			lockflags &= ~1;
			rc = DosSetFileLocks(fd,&UnlockArea,&LockArea,0,lockflags);
		}
		if (request == F_SETLKW && lockinfo->l_type != F_UNLCK) {
			self->state = (lockinfo->l_type == F_RDLCK) ? PS_FDLR_WAIT : PS_FDLW_WAIT;
			while (rc == 33 && !self->sig_pending) {
				rc = DosSetFileLocks(fd,&UnlockArea,&LockArea,1000,lockflags);
			}
			self->state = PS_RUNNING;
	
			if (rc == 33)
				_setsyserrno(EINTR);	
		} else {
			if (rc == 33)
				_setsyserrno(EAGAIN);
		}

		switch (rc) {
		case 1:	/* ERROR_INVALID_FUNCTION */
			_setsyserrno(EPERM);
			break;
		case 6:	/* ERROR_INVALID_HANDLE */
			_setsyserrno(EBADF);
		case 33:
			break;
		case 36:/* ERROR_SHARING_BUFFER_EXCEEDED */
			_setsyserrno(ENOLCK);
			break;
		case 87:/* ERROR_INVALID_PARAMETER */
			_setsyserrno(EINVAL);
			break;
		case 95:/* ERROR_INTERRUPT */
			_setsyserrno(EINTR);
			break;
		case 174:/* NO ATOMIC LOCKS */
		case 175:/* NO READ LOCKS */
			_setsyserrno(EPERM);
		default:
			break;
		}
		return (rc == 0) ? 0 : -1;
	default:
		break;
	}
	_setsyserrno(EINVAL);
	return -1;
}

#endif
